// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse; 
   float4x4 ViewProj:ViewProjection; 

//--------------
// tweaks
//--------------
   float3 AmbientColor={0.1,0.1,0.1};
   float3 LightDirection={0.5,0.5,0.5};
   float3 LightDirectionColor={2.0,2.0,2.0};
   float Heightvec;
 
//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondaryTexture <string Name = "";>;	
   sampler SecondarySampler=sampler_state 
      {
 	Texture=<SecondaryTexture>;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
    	float2 Tex0:TEXCOORD;
 	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
     };
   struct OutPut
     {
	float4 Pos:POSITION;
 	float2 Tex:TEXCOORD0;
  	float3 TBNRow1:TEXCOORD1;
  	float3 TBNRow2:TEXCOORD2;
  	float3 TBNRow3:TEXCOORD3;
  	float3 WorldPos:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     { 
 	OutPut OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex=IN.Tex0;
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(IN.Tangent,World));
	OUT.TBNRow1=Tangent;
	OUT.TBNRow2=cross(Normals,Tangent);
	OUT.TBNRow3=Normals;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=WorldPos;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	return float4(tex2D(BaseSampler,IN.Tex).xyz,0);
     }
   float4 PS_Lighting(OutPut IN) : COLOR
     {
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos);
	float3x3 WorldTBN=float3x3(IN.TBNRow1,IN.TBNRow2,IN.TBNRow3);
	float3 ViewNor=normalize(mul(ViewVec,transpose(WorldTBN)));
	IN.Tex +=(Heightvec*(saturate(tex2D(SecondarySampler,IN.Tex).w)-0.5))*ViewNor;
	IN.Tex +=(Heightvec*(saturate(tex2D(SecondarySampler,IN.Tex).w)-0.5))*ViewNor;
	IN.Tex +=(Heightvec*(saturate(tex2D(SecondarySampler,IN.Tex).w)-0.5))*ViewNor;
	float4 Diffuse=pow(tex2D(BaseSampler,IN.Tex),float4(2.2,2.2,2.2,1));
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex);
	float4 Secondarys=saturate(tex2D(SecondarySampler,IN.Tex.xy));
	float3 Normals=mul(normalize(float3(NormalMap.yw*2-1,0.75)),WorldTBN);
	float ViewNormal=max(dot(ViewVec,Normals),0);
	float3 Specular=lerp(0.04,Diffuse,NormalMap.x);
	Specular +=(1-Specular)*(1-NormalMap.z)*pow(1-ViewNormal,5);
	float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2);
	float Denominator=Distribution.x-1;
	float3 Lighting=LightDirectionColor*max(dot(LightDirection,Normals),0.0);
	float Translucency=(0.5+dot(-LightDirection,Normals)*0.5)*max(dot(normalize(-LightDirection+ViewVec),ViewVec),0.0);
	float HalfVec=max(dot(normalize(LightDirection+ViewVec),Normals),0)*Denominator+1.0001;
	float3 LightSpecular=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	LightSpecular +=0.1-(0.5+Normals.yyy*0.5)*0.05;
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1-Specular)*(1-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*25);
	Lighting +=Translucency*pow(float3(Diffuse.x,Diffuse.y*0.75,Diffuse.z*0.5),1-Secondarys.z)*Secondarys.z*LightDirectionColor;
	return float4(pow(Lighting+LightSpecular*Specular,0.4545),Diffuse.w);
     }

//--------------
// techniques   
//--------------
   technique Texture
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS();
      }
      }
   technique Lighting
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Lighting();
  	AlphaRef=32;
      }
      }


